---
name: docker-devops
description: Docker and Docker Compose development standards. Use when creating Dockerfiles, docker-compose.yml, or configuring containerized environments. Enforces multi-stage builds, Alpine base images, layer caching optimization, security best practices.
---

# Docker DevOps Standards

Стандарты разработки Docker и Docker Compose для оптимальных, безопасных и кешируемых образов.

## Принципы

- **Multi-stage builds** — разделение сборки и runtime
- **Alpine base** — минимальные базовые образы
- **Layer caching** — максимальное переиспользование слоёв
- **Security first** — non-root пользователи, минимум привилегий
- **Reproducibility** — фиксированные версии и теги

## Context7 Integration

Для получения актуальной документации используй Context7:

```
# Docker documentation
Library ID: /llmstxt/docker_llms_txt

# Docker Compose
Library ID: /docker/compose
```

## Структура Dockerfile

```dockerfile
# 1. Build stage — компиляция/сборка
FROM node:22-alpine AS builder
# установка зависимостей, сборка

# 2. Production stage — только runtime
FROM node:22-alpine AS production
# копирование артефактов, запуск
```

## Референсы

| Тема | Файл |
|------|------|
| Multi-stage Dockerfile | [dockerfile.md](dockerfile.md) |
| Docker Compose | [compose.md](compose.md) |
| Layer Caching | [caching.md](caching.md) |
| Security | [security.md](security.md) |

## Базовые образы

| Технология | Базовый образ | Примечание |
|------------|---------------|------------|
| Node.js | `node:22-alpine` | LTS версия |
| Ruby | `ruby:3.3-alpine` | Требует build-base для gems |
| Python | `python:3.12-alpine` | Требует gcc для некоторых пакетов |
| Go | `golang:1.22-alpine` | Scratch для финального образа |
| Nginx | `nginx:alpine` | Для статики |

## Чеклист

- [ ] Multi-stage build (builder → production)
- [ ] Alpine базовый образ
- [ ] Файлы зависимостей копируются первыми (package.json, Gemfile)
- [ ] `.dockerignore` настроен
- [ ] Non-root пользователь в production
- [ ] HEALTHCHECK определён
- [ ] Фиксированные версии образов (не `latest`)
- [ ] Минимум слоёв (объединение RUN команд)
