---
name: react-frontend
description: React frontend development standards with Vite, TailwindCSS. Use when writing React components, hooks, pages, tests. Enforces SOLID, DRY, modular architecture, performance optimization, Vitest unit tests, Playwright E2E tests.
---

# React Frontend Standards

Стандарты разработки React приложений с Vite и TailwindCSS.

## Принципы

- **SOLID** — Single Responsibility для компонентов и хуков
- **DRY** — переиспользуемые компоненты и хуки
- **Composition over Inheritance** — композиция компонентов
- **Colocation** — держи связанный код рядом

## Структура проекта

```
src/
├── app/                    # App shell, providers, router
├── components/             # Shared UI компоненты
│   └── ui/                 # Базовые UI элементы (Button, Input)
├── features/               # Feature-based модули
│   └── auth/
│       ├── components/     # Компоненты фичи
│       ├── hooks/          # Хуки фичи
│       ├── api/            # API запросы
│       └── types.ts        # Типы фичи
├── hooks/                  # Shared хуки
├── lib/                    # Утилиты, хелперы
├── pages/                  # Страницы (роуты)
├── services/               # API клиенты
├── stores/                 # Глобальное состояние
└── types/                  # Глобальные типы
```

## Референсы

| Тема | Файл |
|------|------|
| Архитектура проекта | [architecture.md](architecture.md) |
| Компоненты | [components.md](components.md) |
| Кастомные хуки | [hooks.md](hooks.md) |
| State Management | [state.md](state.md) |
| Производительность | [performance.md](performance.md) |
| Unit тесты (Vitest) | [unit-testing.md](unit-testing.md) |
| E2E тесты (Playwright) | [e2e-testing.md](e2e-testing.md) |

## Стек

```json
{
  "build": "vite",
  "framework": "react",
  "language": "typescript",
  "styling": "tailwindcss",
  "client-state": "zustand",
  "server-state": "@tanstack/react-query",
  "unit-tests": "vitest + @testing-library/react",
  "e2e-tests": "playwright"
}
```

## Ключевые библиотеки

```bash
# Core
npm install react react-dom react-router-dom

# State Management
npm install zustand @tanstack/react-query

# Styling
npm install -D tailwindcss postcss autoprefixer

# Utilities
npm install clsx tailwind-merge

# Testing
npm install -D vitest @testing-library/react @testing-library/user-event jsdom
npm install -D @playwright/test
```

## Чеклист

- [ ] Компоненты — одна ответственность
- [ ] Хуки — бизнес-логика отделена от UI
- [ ] Zustand — клиентское состояние
- [ ] TanStack Query — серверное состояние
- [ ] Мемоизация — useMemo/useCallback где нужно
- [ ] Unit тесты — каждый компонент
- [ ] E2E тесты — критические пути
- [ ] TypeScript — строгая типизация
