---
name: ruby-backend
description: Ruby on Rails backend development standards. Use when writing Rails API code, services, serializers, models, decorators, controllers, or RSpec tests. Enforces SOLID, DRY, Command pattern for services, JSON:API serialization, thin controllers.
---

# Ruby Backend Standards

Стандарты разработки Ruby on Rails API бэкенда.

## Принципы

- **SOLID** — все 5 принципов
- **DRY** — не повторяйся
- **Command Pattern** — для сервисов
- **Thin Controllers** — логика в сервисах

## Структура

```
app/
├── controllers/api/v1/   # API контроллеры
├── models/               # Только relations, scopes, validations
├── services/             # Бизнес-логика
├── serializers/          # JSON:API
├── decorators/           # Презентация
└── queries/              # Сложные запросы
```

## Референсы

| Тема | Файл |
|------|------|
| Сервисы (Command pattern) | [services.md](services.md) |
| JSON:API сериализаторы | [serializers.md](serializers.md) |
| Модели | [models.md](models.md) |
| Декораторы | [decorators.md](decorators.md) |
| API контроллеры | [controllers.md](controllers.md) |
| Query Objects | [queries.md](queries.md) |
| RSpec тестирование | [testing.md](testing.md) |

## Гемы

```ruby
gem 'jsonapi-serializer'
gem 'draper'

group :test do
  gem 'rspec-rails'
  gem 'factory_bot_rails'
  gem 'faker'
  gem 'shoulda-matchers'
end
```

## Чеклист

- [ ] Логика в сервисах (`ApplicationService`)
- [ ] JSON:API ответы через сериализаторы
- [ ] Модели без логики
- [ ] Презентация в декораторах
- [ ] RSpec тесты с FactoryBot
