# frozen_string_literal: true

# Base API controller
# Copy to: app/controllers/api/v1/application_controller.rb
#
module Api
  module V1
    class ApplicationController < ActionController::API
      rescue_from ActiveRecord::RecordNotFound, with: :not_found
      rescue_from ActionController::ParameterMissing, with: :bad_request

      private

      def not_found(exception)
        render json: { errors: [{ detail: exception.message }] }, status: :not_found
      end

      def bad_request(exception)
        render json: { errors: [{ detail: exception.message }] }, status: :bad_request
      end

      def render_errors(errors, status: :unprocessable_entity)
        render json: { errors: Array(errors).map { |e| { detail: e } } }, status: status
      end

      def render_resource(resource, serializer:, status: :ok, **options)
        render json: serializer.new(resource, options).serializable_hash, status: status
      end
    end
  end
end
