# frozen_string_literal: true

# Base service class implementing Command pattern
# Copy to: app/services/application_service.rb
#
# Usage:
#   result = Users::CreateService.call(params: { email: 'test@example.com' })
#   result.success? # => true/false
#   result.data     # => created object
#   result.errors   # => error messages array
#
class ApplicationService
  def self.call(...)
    new(...).call
  end

  def call
    raise NotImplementedError, "#{self.class} must implement #call"
  end

  private

  def success(data = nil)
    ServiceResult.new(success: true, data: data)
  end

  def failure(errors)
    ServiceResult.new(success: false, errors: Array(errors))
  end
end

class ServiceResult
  attr_reader :data, :errors

  def initialize(success:, data: nil, errors: [])
    @success = success
    @data = data
    @errors = errors
    freeze
  end

  def success? = @success
  def failure? = !@success

  def deconstruct_keys(_keys)
    { success: @success, data: @data, errors: @errors }
  end
end
