# frozen_string_literal: true

# Base decorator class
# Copy to: app/decorators/application_decorator.rb
#
# Usage:
#   @user = User.find(id).decorate
#   @users = UserDecorator.decorate_collection(User.all)
#
class ApplicationDecorator < Draper::Decorator
  delegate_all

  def formatted_date(date, format = '%d.%m.%Y')
    date&.strftime(format)
  end

  def formatted_datetime(datetime)
    datetime&.strftime('%d.%m.%Y %H:%M')
  end
end
