# frozen_string_literal: true

# Base query object
# Copy to: app/queries/application_query.rb
#
# Usage:
#   users = Users::SearchQuery.call(params: { status: 'active', q: 'john' })
#
class ApplicationQuery
  def self.call(...) = new(...).call

  def initialize(params = {})
    @params = params
  end

  def call
    raise NotImplementedError
  end

  private

  attr_reader :params

  def paginate(scope, page: 1, per_page: 25)
    scope.limit(per_page).offset((page.to_i - 1) * per_page)
  end

  def search(scope, columns:, query:)
    return scope if query.blank?
    conditions = columns.map { |c| "#{c} ILIKE :q" }.join(' OR ')
    scope.where(conditions, q: "%#{query}%")
  end
end
