# frozen_string_literal: true

# RSpec configuration
# Add to: spec/rails_helper.rb
#
RSpec.configure do |config|
  config.include FactoryBot::Syntax::Methods
end

Shoulda::Matchers.configure do |config|
  config.integrate do |with|
    with.test_framework :rspec
    with.library :rails
  end
end

# Request spec helpers
module RequestHelpers
  def json_response
    JSON.parse(response.body, symbolize_names: true)
  end

  def json_data = json_response[:data]
  def json_errors = json_response[:errors]
end

RSpec.configure do |config|
  config.include RequestHelpers, type: :request
end

# Service spec helpers
module ServiceHelpers
  def expect_success(result)
    expect(result).to be_success
    expect(result.errors).to be_empty
  end

  def expect_failure(result)
    expect(result).to be_failure
    expect(result.errors).not_to be_empty
  end
end

RSpec.configure do |config|
  config.include ServiceHelpers, type: :service
end
